
function TogglePersianCalendarYearPopUpMenu(divYearId,divHeader,visibleYear,controlID)
{
    var divYears = document.getElementById(divYearId);
    var startYear = visibleYear - 5;
    CreateDynamicYearTable(divYears,visibleYear,startYear,controlID);
    divYears.style.position = 'fixed';
    divYears.style.left = findPosX(divHeader) + 'px';
    divYears.style.top =  findPosY(divHeader) + 'px';
    divYears.style.visibility = (divYears.style.visibility=='visible') ? 'hidden' : 'visible';   
}

function CreateDynamicYearTable(divYears,visibleYear,startYear,controlID)
{
    var myTable = document.createElement("table");
    var myTableBody = document.createElement("tbody");
    
    //create Up button
    CreateDynamicYearTableUpButton(myTableBody,visibleYear);
    
    //create table Rows
    CreateDynamicYearTableRows(startYear,myTableBody,visibleYear,controlID);
    
    //create Down Button
    CreateDynamicYearTableDownButton(myTableBody,visibleYear);
    
    
    myTable.appendChild(myTableBody);
    divYears.appendChild(myTable);
}

function CreateDynamicYearTableUpButton(tableBody,visibleYear)
{
    tempTableRow = document.createElement("tr");
    tempTableCell = document.createElement("td");
    tempDivYear = document.createElement("div");
    
    tempDivYear.style.cursor = 'pointer';

    imgUpArrow = document.createElement("img");
    imgUpArrow.src = PersianCalendarClientResources[0];
    imgUpArrow.attachEvent('onclick',function() {shiftDynamicYearMenuRows(-1,visibleYear)});
    
    
    tempDivYear.appendChild(imgUpArrow);

    imgFastUpArrow = document.createElement("img");
    imgFastUpArrow.src = PersianCalendarClientResources[2];
    imgFastUpArrow.attachEvent('onclick',function() {shiftDynamicYearMenuRows(-10,visibleYear)});
    
    tempDivYear.appendChild(imgFastUpArrow);
    
    tempTableCell.appendChild(tempDivYear);
    tempTableRow.appendChild(tempTableCell);
    tableBody.appendChild(tempTableRow);
}

function CreateDynamicYearTableDownButton(tableBody,visibleYear)
{
    tempTableRow = document.createElement("tr");
    tempTableCell = document.createElement("td");
    tempDivYear = document.createElement("div");
    
    tempDivYear.style.cursor = 'pointer';

    imgDownArrow = document.createElement("img");
    imgDownArrow.attachEvent('onclick',function() {shiftDynamicYearMenuRows(1,visibleYear);});
    imgDownArrow.src = PersianCalendarClientResources[1];
    
    tempDivYear.appendChild(imgDownArrow);

    imgFastDownArrow = document.createElement("img");
    imgFastDownArrow.src = PersianCalendarClientResources[3];
    imgFastDownArrow.attachEvent('onclick',function() {shiftDynamicYearMenuRows(10,visibleYear)});
    
    tempDivYear.appendChild(imgFastDownArrow);

    
    tempTableCell.appendChild(tempDivYear);
    tempTableRow.appendChild(tempTableCell);
    tableBody.appendChild(tempTableRow);

}


function shiftDynamicYearMenuRows(shiftNumber,visibleYear,controlID)
{
    var yearsTableBody = event.srcElement.parentElement.parentElement.parentElement.parentElement;
    for (i = 1 ; i < yearsTableBody.childNodes.length-1 ; i++)
    {
        var tempTextNode = yearsTableBody.childNodes(i).childNodes(0).childNodes(0).childNodes(0);
        var newValue = Number(tempTextNode.nodeValue) + shiftNumber;
        tempTextNode.nodeValue = newValue;
        if(visibleYear==newValue)
        {
            tempTextNode.parentNode.detachEvent('onclick',function() {DivYearMenuItemEventHandler(controlID)});
            tempTextNode.parentNode.style.color = 'red';
        }
        else
        {
            tempTextNode.parentNode.attachEvent('onclick',function() {DivYearMenuItemEventHandler(controlID)});
            tempTextNode.parentNode.style.color = 'black';
        }
        
    }
}

function CreateDynamicYearTableRows(startYear,tableBody,visibleYear,controlID)
{
    
    if(startYear < 100)
    {
        startYear = 100
    }
    for (i = startYear ; i < startYear + 10; i++)
    {
        tempTableRow = CreateYearMenuItem(i,i != visibleYear,controlID);
        tableBody.appendChild(tempTableRow);
    }
}

function CreateYearMenuItem(year,enable,controlID)
{
    var tempTableRow = document.createElement("tr");
    var tempTableCell = document.createElement("td");
    var tempDivYear = document.createElement("div");
    
    if(enable)
    {
        tempDivYear.style.cursor='pointer';
        tempDivYear.attachEvent('onclick',function() {DivYearMenuItemEventHandler(controlID)});
    }
    else
    {
        tempDivYear.style.color = 'red';
    }
    tempDivYear.innerText = year;
    
    tempTableCell.appendChild(tempDivYear);
    tempTableRow.appendChild(tempTableCell);
    return tempTableRow;
}

function DivYearMenuItemEventHandler(controlID)
{
     __doPostBack(controlID,'PY' + event.srcElement.innerText);
}



function TogglePersianCalendarMonthPopUpMenu(divMonthId,divHeader)
{
    var divMonths = document.getElementById(divMonthId);
    divMonths.style.position = 'fixed';
    divMonths.style.left = findPosX(divHeader) + 'px';
    divMonths.style.top =  findPosY(divHeader) + 'px';
    divMonths.style.visibility = (divMonths.style.visibility=='visible') ? 'hidden' : 'visible';   
}

function findPosX(obj)
{
    var posx = 0;
	if (!e) var e = window.event;
	if (e.pageX)
	{
		posx = e.pageX;
	}
	else if (e.clientX)
	{
		posx = e.clientX;
	}
	return posx;
}

function findPosY(obj)
{
	var posy = 0;
	if (!e) var e = window.event;
	if (e.pageY)
	{
		posy = e.pageY;
	}
	else if (e.clientY)
	{
		posy = e.clientY;
	}
	return posy;
}


